#include <iostream>
#include <vector>
#include <cmath>
#include <algorithm>

using namespace std;

int solve(vector<int> arr, int n) {
    float median, r1, r2;
    
    sort(arr.begin(), arr.end());
    
    if (n % 2 != 0) {
        return arr[n / 2];
    }
    
    median = (float)(arr[n / 2 - 1] + arr[n / 2]) / 2.0;
    
    r1 = abs(arr[n / 2 - 1] - median);
    r2 = abs(arr[n / 2] - median);
    
    return (r1 < r2) ? arr[n / 2 - 1] : arr[n / 2];
}

int main() {
    ios_base::sync_with_stdio(false); cin.tie(0); cout.tie(0);
    
    int n, m, lm, rm, res = 0, x;
    cin >> n >> m;
    
    vector<int> r(n), l(n);
    
    for (int i = 0; i < n; ++i) {
        cin >> l[i] >> r[i];
    }
    
    lm = solve(l, n);
    rm = solve(r, n);
    
    for (int i = 0; i < n; ++i) {
        x = (min(abs(lm - l[i]), abs(rm - r[i])) == abs(lm - l[i])) ? lm - l[i] : rm - r[i];
        
        l[i] += x;
        r[i] += x;
        
        res += abs(x);
        
        lm = l[i];
        rm = r[i];
    }
    
    cout << res;
}